/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicTextureLoader {
    private static final Logger log = LogManager.getLogger(DynamicTextureLoader.class);
    private static final Map<ResourceLocation, Boolean> EXISTING_TEXTURES = new HashMap<ResourceLocation, Boolean>();
    private static final Set<ResourceLocation> SKIPPED_TEXTURES = new HashSet<ResourceLocation>();

    public static void clearCache() {
        EXISTING_TEXTURES.clear();
        SKIPPED_TEXTURES.clear();
    }

    public static void init(RegisterClientReloadListenersEvent event) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TextureStitchEvent.Post.class, e -> DynamicTextureLoader.clearCache());
    }

    public static boolean textureExists(ResourceManager manager, ResourceLocation location) {
        Boolean found = EXISTING_TEXTURES.get(location);
        if (found == null) {
            found = manager.m_7165_(new ResourceLocation(location.m_135827_(), "textures/" + location.m_135815_() + ".png"));
            EXISTING_TEXTURES.put(location, found);
        }
        return found;
    }

    public static void logMissingTexture(ResourceLocation location) {
        if (!SKIPPED_TEXTURES.contains(location)) {
            SKIPPED_TEXTURES.add(location);
            log.debug("Skipping loading texture '{}' as it does not exist in the resource pack", (Object)location);
        }
    }

    public static Predicate<Material> getTextureAdder(Collection<Material> allTextures, boolean logMissingTextures) {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        return mat -> {
            ResourceLocation loc = mat.m_119203_();
            if (!InventoryMenu.f_39692_.equals((Object)mat.m_119193_()) || DynamicTextureLoader.textureExists(manager, loc)) {
                allTextures.add((Material)mat);
                return true;
            }
            if (logMissingTextures) {
                DynamicTextureLoader.logMissingTexture(loc);
            }
            return false;
        };
    }
}

